/* 
 * Sony Programmable I/O Control Device (SPIC) driver for VAIO. 
 * Userspace Control Utility
 *
 * Copyright 2001 Stelian Pop, Alcove
 * Modified by Akkana, http://www.shallowsky.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <getopt.h>
#include <errno.h>
#include <limits.h>
#include <ctype.h>

#include <linux/sonypi.h>

/* Function prototypes */
int main(int, char *[]);
static int spic_ioctl(int, __u8 *);

/*
 * Main function.
 */
int main(int argc, char *argv[])
{
    __u32 value = ULONG_MAX;
    __u8 value8;

    if (argc > 1)
    {
        if (!isdigit(argv[1][0])) {
            fprintf(stderr, "Usage: %s [0-255]\n", argv[0]);
            exit(1);
        }
        value = atoi(argv[1]);
        if (value == ULONG_MAX) {
            fprintf(stderr, "%s: Bad value (should be 0 - 255): %s\n",
                    argv[0], argv[1]);
            exit(1);
        }
    }

    if (value == ULONG_MAX)    // Get current brightness
    {
        if (spic_ioctl(SONYPI_IOCGBRT, &value8) >= 0)
            printf("%d\n", (int)value8);
        else perror("Couldn't get brightness");
    }
    else
    {
        value8 = (__u8) value;
        spic_ioctl(SONYPI_IOCSBRT, &value8);
    }

    return 0;
}

/*
 * Sends a ioctl command to the SPIC driver.
 *
 * Return: 0 if success, -1 if an error occured.
 */
static int spic_ioctl(int ioctlno, __u8 *param) {
	int fd;

	if ( (fd = open("/dev/sonypi", O_RDWR)) == -1) {
		fprintf(stderr, "Failed to open /dev/sonypi: %s\n", 
			strerror(errno));
		return -1;
	}
	if (ioctl(fd, ioctlno, param) < 0) {
		fprintf(stderr, "ioctl failed: %s\n", strerror(errno));
		return -1;
	}
	close(fd);
	return 0;
}

